//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Collections.Specialized;

namespace HTMLViewer
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class HTMLForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label webAddressLabel;
		private System.Windows.Forms.Button htmlSource;
		private System.Windows.Forms.TextBox sourceTextBox;
		private System.Windows.Forms.Button closeButton;
		private string strSource = null;
		HTMLPageGet page;
		// Identyfikatory schematu
		private const string HTTP = "http://";
		private const string HTTPS = "https://";
		private const string FILE = "file://";

		private System.Windows.Forms.TextBox url;
		private System.Windows.Forms.ColumnHeader nameColumn;
		private System.Windows.Forms.ColumnHeader valueColumn;
		private System.Windows.Forms.ListView propertyList;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public HTMLForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
			this.Height = 100;
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			System.Collections.Specialized.NameValueCollection configurationAppSettings = System.Configuration.ConfigurationSettings.AppSettings;
			this.url = new System.Windows.Forms.TextBox();
			this.closeButton = new System.Windows.Forms.Button();
			this.sourceTextBox = new System.Windows.Forms.TextBox();
			this.htmlSource = new System.Windows.Forms.Button();
			this.webAddressLabel = new System.Windows.Forms.Label();
			this.propertyList = new System.Windows.Forms.ListView();
			this.nameColumn = new System.Windows.Forms.ColumnHeader();
			this.valueColumn = new System.Windows.Forms.ColumnHeader();
			this.SuspendLayout();
			// 
			// url
			// 
			this.url.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.url.Location = new System.Drawing.Point(112, 16);
			this.url.Name = "url";
			this.url.Size = new System.Drawing.Size(384, 22);
			this.url.TabIndex = 1;
			this.url.Text = "http://";
			this.url.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.OnKeyPress);
			// 
			// closeButton
			// 
			this.closeButton.BackColor = System.Drawing.Color.Lavender;
			this.closeButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.closeButton.Location = new System.Drawing.Point(600, 16);
			this.closeButton.Name = "closeButton";
			this.closeButton.TabIndex = 4;
			this.closeButton.Text = "Zamknij";
			this.closeButton.Click += new System.EventHandler(this.OnClose);
			// 
			// sourceTextBox
			// 
			this.sourceTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.sourceTextBox.Location = new System.Drawing.Point(16, 56);
			this.sourceTextBox.Multiline = true;
			this.sourceTextBox.Name = "sourceTextBox";
			this.sourceTextBox.ReadOnly = true;
			this.sourceTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.sourceTextBox.Size = new System.Drawing.Size(664, 488);
			this.sourceTextBox.TabIndex = 3;
			this.sourceTextBox.Text = "";
			this.sourceTextBox.Visible = false;
			// 
			// htmlSource
			// 
			this.htmlSource.BackColor = System.Drawing.Color.Lavender;
			this.htmlSource.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.htmlSource.Location = new System.Drawing.Point(512, 16);
			this.htmlSource.Name = "htmlSource";
			this.htmlSource.TabIndex = 2;
			this.htmlSource.Text = "rdo";
			this.htmlSource.Click += new System.EventHandler(this.OnGetSource);
			// 
			// webAddressLabel
			// 
			this.webAddressLabel.BackColor = System.Drawing.Color.Lavender;
			this.webAddressLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.webAddressLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.webAddressLabel.Location = new System.Drawing.Point(16, 16);
			this.webAddressLabel.Name = "webAddressLabel";
			this.webAddressLabel.Size = new System.Drawing.Size(88, 20);
			this.webAddressLabel.TabIndex = 0;
			this.webAddressLabel.Text = "Adres internetowy";
			// 
			// propertyList
			// 
			this.propertyList.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.nameColumn,
																						   this.valueColumn});
			this.propertyList.Location = new System.Drawing.Point(16, 552);
			this.propertyList.Name = "propertyList";
			this.propertyList.Size = new System.Drawing.Size(664, 264);
			this.propertyList.TabIndex = 5;
			this.propertyList.View = System.Windows.Forms.View.Details;
			this.propertyList.Visible = false;
			// 
			// nameColumn
			// 
			this.nameColumn.Text = configurationAppSettings.Get("nameColumn.Text");
			this.nameColumn.Width = int.Parse(configurationAppSettings.Get("nameColumn.Width"));
			// 
			// valueColumn
			// 
			this.valueColumn.Text = "Warto";
			this.valueColumn.Width = 571;
			// 
			// HTMLForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.AutoScroll = true;
			this.BackColor = System.Drawing.Color.Blue;
			this.ClientSize = new System.Drawing.Size(696, 829);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.propertyList,
																		  this.closeButton,
																		  this.sourceTextBox,
																		  this.htmlSource,
																		  this.url,
																		  this.webAddressLabel});
			this.Name = "HTMLForm";
			this.Text = "Przegldarka HTML";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new HTMLForm());
		}

		private void GetPageSource()
		{
			string strAddress = url.Text.Trim();
			strAddress = strAddress.ToLower();
			if (!strAddress.StartsWith(HTTP) &&
				!strAddress.StartsWith(HTTPS) &&
				!strAddress.StartsWith(FILE))
			{
				MessageBox.Show("Wybrano niewaciwy protok.", "Bdny identyfikator schematu", MessageBoxButtons.OK, MessageBoxIcon.Information);
				url.Text = HTTP;
			}
			else
			{
				// Utworzenie obiektu GetWebPageSource
				page = new HTMLPageGet(strAddress);
				strSource = page.Source;
				showSource();
			}		
		}

		private void showSource()
		{
			propertyList.Items.Clear();
			sourceTextBox.Clear();
			HTMLForm.ActiveForm.Height = 856;
			sourceTextBox.Text = strSource;
			NameValueCollection c = page.SourceProperties;
			string [] keys = c.AllKeys;
			foreach(string key in keys)
			{
				ListViewItem item = new ListViewItem(key);
				item.SubItems.Add(c[key]);
				propertyList.Items.Add(item);
			}
			sourceTextBox.Visible = true;
			sourceTextBox.Refresh();
			propertyList.Visible = true;
			propertyList.Refresh();
		}

		private void OnClose(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void OnKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			char chr = e.KeyChar;
			// 13 = Enter
			if (chr == 13)
			{
				GetPageSource();
			}
		}

		private void OnGetSource(object sender, System.EventArgs e)
		{
			GetPageSource();
		}
	}
}
